<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */

/** @var app\models\LoginForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\helpers\Url;
use yii\widgets\MaskedInput;

$this->title = 'Авторизация';
?>
<div class="auth-container">

    <div class="auth-wrapper">
        <!-- Левая часть с иллюстрацией -->
        <div class="auth-hero">
            <div class="hero-content">
                <h1>С возвращением!</h1>
                <p>Рады видеть вас снова в нашем магазине натуральных продуктов</p>
                <div class="hero-features">
                    <div class="feature-item">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <span>Безопасный вход</span>
                    </div>
                    <div class="feature-item">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                        </svg>
                        <span>Защита данных</span>
                    </div>
                </div>
            </div>
            <div class="floating-elements">
                <div class="floating-element el-1"></div>
                <div class="floating-element el-2"></div>
                <div class="floating-element el-3"></div>
            </div>
        </div>

        <!-- Правая часть с формой -->
        <div class="auth-form-section">
            <div class="form-container">
                <div class="form-header">
                    <h2>Вход в аккаунт</h2>
                    <p>Введите ваши данные для входа</p>
                </div>

                <?php $form = ActiveForm::begin([
                    'id' => 'login-form',
                    'options' => ['class' => 'modern-form'],
                    'fieldConfig' => [
                        'template' => "{label}\n{input}\n{error}",
                        'labelOptions' => ['class' => 'form-label'],
                        'inputOptions' => ['class' => 'form-input'],
                        'errorOptions' => ['class' => 'form-error'],
                    ],
                ]); ?>

                <div class="input-group">
                    <?= $form->field($model, 'phone_number', [
                        'template' => '
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                    </svg>
                                </div>
                                {input}
                                {label}
                            </div>
                            {error}'
                    ])->widget(MaskedInput::class, [
                        'mask' => '8-999-999-99-99',
                        'options' => ['class' => 'form-input', 'placeholder' => ' ']
                    ]) ?>
                </div>

                <div class="input-group">
                    <?= $form->field($model, 'password', [
                        'template' => '
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                    </svg>
                                </div>
                                {input}
                                {label}
                            </div>
                            {error}'
                    ])->passwordInput(['placeholder' => ' ']) ?>
                </div>

                <div class="form-options">
                    <?= $form->field($model, 'rememberMe')->checkbox([
                        'template' => "
                            <label class=\"checkbox-wrapper\">
                                {input}
                                <span class=\"checkmark\"></span>
                                <span class=\"checkbox-label\">{label}</span>
                            </label>",
                        'labelOptions' => ['class' => '']
                    ]) ?>
                </div>

                <div class="form-actions">
                    <?= Html::submitButton('Войти в аккаунт', [
                        'class' => 'btn-primary',
                        'name' => 'login-button'
                    ]) ?>
                </div>

                <div class="form-footer">
                    <p>Еще нет аккаунта?
                        <a href="<?= Url::toRoute(['site/signup']); ?>" class="auth-link">
                            Зарегистрироваться
                        </a>
                    </p>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>

<style>
    .auth-container {
        min-height: 100vh;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 2rem;
    }

    .auth-wrapper {
        display: grid;
        grid-template-columns: 1fr 1fr;
        max-width: 1200px;
        width: 100%;
        background: white;
        border-radius: 2rem;
        overflow: hidden;
        box-shadow: 0 25px 50px rgba(0, 0, 0, 0.1);
        min-height: 700px;
    }

    /* Левая часть */
    .auth-hero {
        position: relative;
        background: linear-gradient(135deg, #aaeff8ff 0%, #764ba2 100%);
        color: white;
        padding: 3rem;
        display: flex;
        flex-direction: column;
        justify-content: center;
        overflow: hidden;
    }

    .hero-content h1 {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
        line-height: 1.2;
    }

    .hero-content p {
        font-size: 1.1rem;
        opacity: 0.9;
        margin-bottom: 2rem;
    }

    .hero-features {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .feature-item {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        font-size: 1rem;
    }

    .feature-item svg {
        opacity: 0.8;
    }

    /* Анимированные элементы */
    .floating-elements {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
    }

    .floating-element {
        position: absolute;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.1);
    }

    .el-1 {
        width: 120px;
        height: 120px;
        top: 10%;
        right: 10%;
        animation: float 8s ease-in-out infinite;
    }

    .el-2 {
        width: 80px;
        height: 80px;
        bottom: 20%;
        left: 15%;
        animation: float 6s ease-in-out infinite 1s;
    }

    .el-3 {
        width: 60px;
        height: 60px;
        top: 50%;
        right: 20%;
        animation: float 7s ease-in-out infinite 0.5s;
    }

    @keyframes float {
        0%, 100% { transform: translateY(0px) rotate(0deg); }
        50% { transform: translateY(-20px) rotate(180deg); }
    }

    /* Правая часть */
    .auth-form-section {
        padding: 3rem;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .form-container {
        width: 100%;
        max-width: 400px;
    }

    .form-header {
        text-align: center;
        margin-bottom: 2.5rem;
    }

    .form-header h2 {
        font-size: 2rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 0.5rem;
    }

    .form-header p {
        color: #6b7280;
        font-size: 1rem;
    }

    /* Форма */
    .modern-form {
        width: 100%;
    }

    .input-group {
        margin-bottom: 1.5rem;
    }

    .input-wrapper {
        position: relative;
    }

    .form-input {
        width: 100%;
        padding: 1rem 1rem 1rem 3rem;
        border: 2px solid #e5e7eb;
        border-radius: 0.75rem;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: white;
    }

    .form-input:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-label {
        position: absolute;
        left: 3rem;
        top: 1rem;
        color: #9ca3af;
        transition: all 0.3s ease;
        pointer-events: none;
        background: white;
        padding: 0 0.25rem;
    }

    .form-input:focus + .form-label,
    .form-input:not(:placeholder-shown) + .form-label {
        top: -0.5rem;
        left: 0.75rem;
        font-size: 0.875rem;
        color: #667eea;
        font-weight: 500;
    }

    .input-icon {
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
        z-index: 2;
    }

    .form-input:focus ~ .input-icon {
        color: #667eea;
    }

    .form-error {
        color: #ef4444;
        font-size: 0.875rem;
        margin-top: 0.5rem;
        display: block;
    }

    /* Чекбокс */
    .form-options {
        margin-bottom: 2rem;
    }

    .checkbox-wrapper {
        display: flex;
        align-items: center;
        cursor: pointer;
        gap: 0.75rem;
    }

    .checkbox-wrapper input {
        display: none;
    }

    .checkmark {
        width: 20px;
        height: 20px;
        border: 2px solid #d1d5db;
        border-radius: 0.375rem;
        position: relative;
        transition: all 0.3s ease;
    }

    .checkbox-wrapper input:checked + .checkmark {
        background: #667eea;
        border-color: #667eea;
    }

    .checkbox-wrapper input:checked + .checkmark::after {
        content: '';
        position: absolute;
        left: 6px;
        top: 2px;
        width: 5px;
        height: 10px;
        border: solid white;
        border-width: 0 2px 2px 0;
        transform: rotate(45deg);
    }

    .checkbox-label {
        color: #374151;
        font-size: 0.875rem;
    }

    /* Кнопка */
    .form-actions {
        margin-bottom: 2rem;
    }

    .btn-primary {
        width: 100%;
        padding: 1rem 2rem;
        background: linear-gradient(135deg, #aaeff8ff 0%, #764ba2 100%);
        color: white;
        border: none;
        border-radius: 0.75rem;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
    }

    /* Футер формы */
    .form-footer {
        text-align: center;
        padding-top: 2rem;
        border-top: 1px solid #e5e7eb;
    }

    .form-footer p {
        color: #6b7280;
        margin: 0;
    }

    .auth-link {
        color: #667eea;
        text-decoration: none;
        font-weight: 600;
        transition: color 0.3s ease;
    }

    .auth-link:hover {
        color: #764ba2;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .auth-wrapper {
            grid-template-columns: 1fr;
            min-height: auto;
        }

        .auth-hero {
            display: none;
        }

        .auth-form-section {
            padding: 2rem 1.5rem;
        }

        .form-header h2 {
            font-size: 1.75rem;
        }
    }
</style>