<?php

/** @var yii\web\View $this */

use yii\bootstrap5\Html;
use yii\helpers\Url;

$this->title = 'FreshMarket - Натуральные продукты';
?>
<div class="site-index">

    <!-- Hero Section -->
    <div class="hero-section">
        <div class="hero-content text-center">
            <h1 class="hero-title">Натуральные продукты <br>с доставкой</h1>
            <p class="hero-subtitle">Фермерские товары прямо к вашему столу</p>
            <div class="hero-actions">
                <a href="<?= Url::to(['site/application']) ?>" class="btn-hero-primary">
                    <span>Начать покупки</span>
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                        <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2"/>
                    </svg>
                </a>
                <a href="#products" class="btn-hero-secondary">Смотреть ассортимент</a>
            </div>
        </div>
        <div class="hero-background">
            <div class="floating-shapes">
                <div class="shape shape-1"></div>
                <div class="shape shape-2"></div>
                <div class="shape shape-3"></div>
            </div>
        </div>
    </div>

    <!-- Features Grid -->
    <div class="features-section" id="products">
        <div class="container">
            <h2 class="section-title">Почему выбирают нас</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">
                        <svg width="40" height="40" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                        </svg>
                    </div>
                    <h3>Прямые поставки</h3>
                    <p>Работаем напрямую с фермерами без посредников</p>
                </div>

                <div class="feature-card">
                    <div class="feature-icon">
                        <svg width="40" height="40" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M20.59 13.41l-7.17 7.17a2 2 0 01-2.83 0L2 12V2h10l8.59 11.41zM7 7h.01"/>
                        </svg>
                    </div>
                    <h3>Свежесть гарантирована</h3>
                    <p>Доставляем в день сбора или производства</p>
                </div>

                <div class="feature-card">
                    <div class="feature-icon">
                        <svg width="40" height="40" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/>
                        </svg>
                    </div>
                    <h3>Качество проверено</h3>
                    <p>Строгий контроль на всех этапах</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Products Showcase -->
    <div class="products-section">
        <div class="container">
            <h2 class="section-title">Наша продукция</h2>
            <div class="products-grid">
                <div class="product-card">
                    <div class="product-image">
                        <?= Html::img('@web/images/1.jpg', ['alt' => 'Мясная продукция']) ?>
                        <div class="product-overlay">
                            <span class="product-category">Мясо</span>
                        </div>
                    </div>
                    <div class="product-content">
                        <h3>Мясная продукция</h3>
                        <p>Свежее мясо от фермерских хозяйств</p>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <?= Html::img('@web/images/2.webp', ['alt' => 'Молочные продукты']) ?>
                        <div class="product-overlay">
                            <span class="product-category">Молочное</span>
                        </div>
                    </div>
                    <div class="product-content">
                        <h3>Молочные продукты</h3>
                        <p>Натуральные молочные продукты</p>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <?= Html::img('@web/images/3.jpg', ['alt' => 'Варенье']) ?>
                        <div class="product-overlay">
                            <span class="product-category">Сладости</span>
                        </div>
                    </div>
                    <div class="product-content">
                        <h3>Домашние заготовки</h3>
                        <p>Варенья и консервация ручной работы</p>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <?= Html::img('@web/images/4.jpg', ['alt' => 'Мед']) ?>
                        <div class="product-overlay">
                            <span class="product-category">Мед</span>
                        </div>
                    </div>
                    <div class="product-content">
                        <h3>Натуральный мед</h3>
                        <p>Мед с собственных пасек</p>
                    </div>
                </div>

                <div class="product-card">
                    <div class="product-image">
                        <?= Html::img('@web/images/5.jpg', ['alt' => 'Овощи и фрукты']) ?>
                        <div class="product-overlay">
                            <span class="product-category">Овощи/Фрукты</span>
                        </div>
                    </div>
                    <div class="product-content">
                        <h3>Овощи и фрукты</h3>
                        <p>Сезонные продукты с грядки</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA Section -->
    <div class="cta-section">
        <div class="container">
            <div class="cta-content">
                <h2>Готовы попробовать?</h2>
                <p>Присоединяйтесь к тысячам довольных клиентов</p>
                <a href="<?= Url::to(['site/application']) ?>" class="btn-cta">
                    Сделать первый заказ
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                        <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2"/>
                    </svg>
                </a>
            </div>
        </div>
    </div>

</div>

<style>
    /* Hero Section */
    .hero-section {
        position: relative;
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, #aaeff8ff 0%, #764ba2 100%);
        overflow: hidden;
    }

    .hero-content {
        position: relative;
        z-index: 2;
        color: white;
    }

    .hero-title {
        font-size: 3.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
        line-height: 1.2;
    }

    .hero-subtitle {
        font-size: 1.5rem;
        margin-bottom: 2.5rem;
        opacity: 0.9;
    }

    .hero-actions {
        display: flex;
        gap: 1rem;
        justify-content: center;
        flex-wrap: wrap;
    }

    .btn-hero-primary {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        padding: 1rem 2rem;
        background: #10b981;
        color: white;
        text-decoration: none;
        border-radius: 50px;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .btn-hero-primary:hover {
        background: #059669;
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(16, 185, 129, 0.3);
    }

    .btn-hero-secondary {
        padding: 1rem 2rem;
        border: 2px solid white;
        color: white;
        text-decoration: none;
        border-radius: 50px;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .btn-hero-secondary:hover {
        background: white;
        color: #667eea;
    }

    /* Floating Shapes */
    .floating-shapes {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
    }

    .shape {
        position: absolute;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.1);
    }

    .shape-1 {
        width: 100px;
        height: 100px;
        top: 10%;
        left: 10%;
        animation: float 6s ease-in-out infinite;
    }

    .shape-2 {
        width: 150px;
        height: 150px;
        top: 60%;
        right: 10%;
        animation: float 8s ease-in-out infinite;
    }

    .shape-3 {
        width: 80px;
        height: 80px;
        bottom: 20%;
        left: 20%;
        animation: float 7s ease-in-out infinite;
    }

    @keyframes float {
        0%, 100% { transform: translateY(0px) rotate(0deg); }
        50% { transform: translateY(-20px) rotate(180deg); }
    }

    /* Sections Common */
    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 2rem;
    }

    .section-title {
        text-align: center;
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 3rem;
        color: #1f2937;
    }

    /* Features Section */
    .features-section {
        padding: 5rem 0;
        background: #f8fafc;
    }

    .features-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 2rem;
    }

    .feature-card {
        text-align: center;
        padding: 2rem;
        background: white;
        border-radius: 1rem;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        transition: transform 0.3s ease;
    }

    .feature-card:hover {
        transform: translateY(-5px);
    }

    .feature-icon {
        width: 80px;
        height: 80px;
        margin: 0 auto 1.5rem;
        background: #eff6ff;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #3b82f6;
    }

    .feature-card h3 {
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 1rem;
        color: #1f2937;
    }

    .feature-card p {
        color: #6b7280;
        line-height: 1.6;
    }

    /* Products Section */
    .products-section {
        padding: 5rem 0;
    }

    .products-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 2rem;
    }

    .product-card {
        background: white;
        border-radius: 1rem;
        overflow: hidden;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
    }

    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 25px rgba(0, 0, 0, 0.1);
    }

    .product-image {
        position: relative;
        height: 250px;
        overflow: hidden;
    }

    .product-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }

    .product-card:hover .product-image img {
        transform: scale(1.1);
    }

    .product-overlay {
        position: absolute;
        top: 1rem;
        left: 1rem;
    }

    .product-category {
        background: #10b981;
        color: white;
        padding: 0.5rem 1rem;
        border-radius: 50px;
        font-size: 0.875rem;
        font-weight: 600;
    }

    .product-content {
        padding: 1.5rem;
    }

    .product-content h3 {
        font-size: 1.25rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
        color: #1f2937;
    }

    .product-content p {
        color: #6b7280;
        line-height: 1.6;
    }

    /* CTA Section */
    .cta-section {
        padding: 5rem 0;
        background: linear-gradient(135deg, #aaeff8ff 0%rgba(8, 207, 221, 1)6c 100%);
        color: white;
    }

    .cta-content {
        text-align: center;
        max-width: 600px;
        margin: 0 auto;
    }

    .cta-content h2 {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
    }

    .cta-content p {
        font-size: 1.25rem;
        margin-bottom: 2rem;
        opacity: 0.9;
    }

    .btn-cta {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        padding: 1rem 2.5rem;
        background: white;
        color: #f5576c;
        text-decoration: none;
        border-radius: 50px;
        font-weight: 600;
        font-size: 1.125rem;
        transition: all 0.3s ease;
    }

    .btn-cta:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(255, 255, 255, 0.3);
    }

    /* Responsive */
    @media (max-width: 768px) {
        .hero-title {
            font-size: 2.5rem;
        }

        .hero-actions {
            flex-direction: column;
            align-items: center;
        }

        .section-title {
            font-size: 2rem;
        }

        .container {
            padding: 0 1rem;
        }
    }
</style>