<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>" class="h-100">
    <head>
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->head() ?>
    </head>
    <body class="d-flex flex-column h-100">
    <?php $this->beginBody() ?>

    <header id="header">
        <?php
        NavBar::begin([
            'brandLabel' => '
            <div class="brand-wrapper">
                <svg class="brand-icon" width="32" height="32" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                </svg>
                <span class="brand-text">EcoEda</span>
            </div>
        ',
            'brandUrl' => Yii::$app->homeUrl,
            'options' => [
                'class' => 'navbar-expand-lg navbar-modern fixed-top',
                'data-bs-theme' => 'dark'
            ],
            'containerOptions' => ['class' => 'container-fluid']
        ]);

        echo Nav::widget([
            'options' => ['class' => 'navbar-nav me-auto'],
            'items' => [
                [
                    'label' => 'Главная',
                    'url' => ['/site/index'],
                    'linkOptions' => ['class' => 'nav-link-with-icon'],
                    'encode' => false
                ],
                [
                    'label' => 'Сделать заказ',
                    'url' => ['/site/application'],
                    'linkOptions' => ['class' => 'nav-link-primary'],
                    'encode' => false
                ],
                [
                    'label' => 'Регистрация',
                    'url' => ['/site/signup'],
                    'visible' => Yii::$app->user->isGuest,
                    'linkOptions' => ['class' => 'nav-link-with-icon'],
                    'encode' => false
                ],
                Yii::$app->user->isGuest ? ('') : (
                Yii::$app->user->identity->isAdmin() ?
                    [
                        'label' => '
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                        </svg>
                        Админ-панель
                    ',
                        'url' => ['/admin/'],
                        'linkOptions' => ['class' => 'nav-link-admin'],
                        'encode' => false
                    ] :
                    [
                        'label' => '
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                        </svg>
                        Мои заказы
                    ',
                        'url' => ['/site/myapplications'],
                        'linkOptions' => ['class' => 'nav-link-with-icon'],
                        'encode' => false
                    ]
                ),
                Yii::$app->user->isGuest
                    ? [
                    'label' => '
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/>
                        </svg>
                        Авторизация
                    ',
                    'url' => ['/site/login'],
                    'linkOptions' => ['class' => 'nav-link-with-icon'],
                    'encode' => false
                ]
                    : '<li class="nav-item dropdown user-menu">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <div class="user-avatar">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 12a4 4 0 100-8 4 4 0 000 8zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                            </svg>
                        </div>
                        <span class="user-name">' . Yii::$app->user->identity->name . '</span>
                    </a>
                    <ul class="dropdown-menu">
                        <li>' . Html::beginForm(['/site/logout'], 'post', ['class' => 'd-inline'])
                    . Html::submitButton(
                        '<svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                                </svg>
                                Выйти',
                        ['class' => 'dropdown-item logout-btn']
                    )
                    . Html::endForm() . '
                        </li>
                    </ul>
                  </li>'
            ]
        ]);
        NavBar::end();
        ?>
    </header>

    <main id="main" class="flex-shrink-0" role="main">
        <div class="container-modern">
            <?php if (!empty($this->params['breadcrumbs'])): ?>
                <nav aria-label="breadcrumb" class="modern-breadcrumb">
                    <?= Breadcrumbs::widget([
                        'links' => $this->params['breadcrumbs'],
                        'options' => ['class' => 'breadcrumb'],
                        'itemTemplate' => '<li class="breadcrumb-item">{link}</li>',
                        'activeItemTemplate' => '<li class="breadcrumb-item active" aria-current="page">{link}</li>'
                    ]) ?>
                </nav>
            <?php endif ?>
            <?= Alert::widget() ?>
            <?= $content ?>
        </div>
    </main>

    <footer id="footer" class="mt-auto py-4">
        <div class="container-modern">
            <div class="footer-content">
                <div class="footer-brand">
                    <div class="brand-wrapper">
                        <svg class="brand-icon" width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                        </svg>
                        <span class="brand-text">EcoEda</span>
                    </div>
                    <p class="footer-tagline">Натуральные продукты с доставкой</p>
                </div>
                <div class="footer-copyright">
                    &copy; <?= date('Y') ?> Эко еда. Все права защищены.
                </div>
            </div>
        </div>
    </footer>

    <?php $this->endBody() ?>

    <style>
        /* Modern Header */
        .navbar-modern {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            backdrop-filter: blur(10px);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            padding: 0.75rem 0;
            transition: all 0.3s ease;
        }

        .brand-wrapper {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            font-weight: 700;
            font-size: 1.5rem;
        }

        .brand-icon {
            color: #10b981;
        }

        .brand-text {
            background: linear-gradient(135deg, #10b981, #3b82f6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* Navigation Links */
        .navbar-nav .nav-link {
            color: rgba(255, 255, 255, 0.9) !important;
            font-weight: 500;
            padding: 0.5rem 1rem !important;
            margin: 0 0.25rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .navbar-nav .nav-link:hover {
            color: white !important;
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-1px);
        }

        .nav-link-primary {
            background: rgba(16, 185, 129, 0.2);
            border: 1px solid rgba(16, 185, 129, 0.3);
        }

        .nav-link-primary:hover {
            background: rgba(16, 185, 129, 0.3) !important;
        }

        .nav-link-admin {
            background: rgba(239, 68, 68, 0.2);
            border: 1px solid rgba(239, 68, 68, 0.3);
        }

        .nav-link-admin:hover {
            background: rgba(239, 68, 68, 0.3) !important;
        }

        .nav-link-with-icon {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        /* User Menu */
        .user-menu .nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            border: 1px solid rgba(255, 255, 255, 0.2) !important;
        }

        .user-avatar {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .user-name {
            font-weight: 600;
        }

        .dropdown-menu {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            padding: 0.5rem;
        }

        .dropdown-item {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
            color: #374151;
            text-decoration: none;
        }

        .dropdown-item:hover {
            background: #f3f4f6;
            color: #1f2937;
        }

        .logout-btn {
            background: none;
            border: none;
            width: 100%;
            text-align: left;
            color: #374151;
            cursor: pointer;
        }

        .logout-btn:hover {
            color: #ef4444;
        }

        /* Main Content */
        .container-modern {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 2rem;
        }

        /* Breadcrumb */
        .modern-breadcrumb {
            margin: 2rem 0 1rem;
        }

        .breadcrumb {
            background: #f8fafc;
            border-radius: 0.75rem;
            padding: 1rem 1.5rem;
            border: 1px solid #e5e7eb;
        }

        .breadcrumb-item {
            color: #6b7280;
            font-weight: 500;
        }

        .breadcrumb-item a {
            color: #667eea;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .breadcrumb-item a:hover {
            color: #764ba2;
        }

        .breadcrumb-item.active {
            color: #374151;
        }

        /* Footer */
        #footer {
            background: linear-gradient(135deg, #1f2937 0%, #374151 100%);
            color: white;
            margin-top: 4rem;
        }

        .footer-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .footer-brand {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .footer-tagline {
            color: #d1d5db;
            margin: 0;
            font-size: 0.875rem;
        }

        .footer-copyright {
            color: #9ca3af;
            font-size: 0.875rem;
        }

        /* Responsive */
        @media (max-width: 991.98px) {
            .navbar-nav {
                padding: 1rem 0;
            }

            .navbar-nav .nav-link {
                margin: 0.25rem 0;
                padding: 0.75rem 1rem !important;
            }

            .footer-content {
                flex-direction: column;
                text-align: center;
            }
        }

        @media (max-width: 768px) {
            .container-modern {
                padding: 0 1rem;
            }

            .brand-text {
                font-size: 1.25rem;
            }
        }

        /* Smooth transitions */
        .navbar-nav .nav-link,
        .dropdown-item,
        .breadcrumb-item a {
            transition: all 0.3s ease;
        }

        /* Focus states */
        .navbar-nav .nav-link:focus,
        .dropdown-item:focus {
            outline: none;
            box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.5);
        }
    </style>

    </body>
    </html>
<?php $this->endPage() ?>