<?php

use yii\helpers\Url;

?>
<div class="admin-dashboard">
    <!-- Header -->
    <div class="admin-header">
        <div class="admin-welcome">
            <h1 class="admin-title">
                <svg width="32" height="32" viewBox="0 0 24 24" fill="currentColor" class="admin-icon">
                    <path d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                </svg>
                Админ-панель
            </h1>
            <p class="admin-subtitle">Панель управления EcoEda</p>
        </div>
        <div class="admin-stats">
            <div class="stat-card">
                <div class="stat-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                    </svg>
                </div>
                <div class="stat-info">
                    <span class="stat-value">24</span>
                    <span class="stat-label">Новых заказов</span>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                    </svg>
                </div>
                <div class="stat-info">
                    <span class="stat-value">156</span>
                    <span class="stat-label">Пользователей</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="quick-actions">
        <h2 class="section-title">Быстрые действия</h2>
        <div class="actions-grid">
            <a href="<?= Url::to(['/admin/application/index']) ?>" class="action-card">
                <div class="action-icon primary">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m2-8h1m-1 4h1m-1 4h1m-7 4v-1m0-4v-1m0-4V8"/>
                    </svg>
                </div>
                <div class="action-content">
                    <h3>Управление заказами</h3>
                    <p>Просмотр и обработка всех заказов</p>
                </div>
                <div class="action-arrow">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 5l7 7-7 7"/>
                    </svg>
                </div>
            </a>

            <div class="action-card coming-soon">
                <div class="action-icon secondary">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                </div>
                <div class="action-content">
                    <h3>Управление пользователями</h3>
                    <p>Скоро будет доступно</p>
                </div>
                <div class="action-badge">Скоро</div>
            </div>

            <div class="action-card coming-soon">
                <div class="action-icon success">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"/>
                    </svg>
                </div>
                <div class="action-content">
                    <h3>Управление товарами</h3>
                    <p>Скоро будет доступно</p>
                </div>
                <div class="action-badge">Скоро</div>
            </div>

            <div class="action-card coming-soon">
                <div class="action-icon warning">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                    </svg>
                </div>
                <div class="action-content">
                    <h3>Аналитика и отчеты</h3>
                    <p>Скоро будет доступно</p>
                </div>
                <div class="action-badge">Скоро</div>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="recent-activity">
        <div class="activity-header">
            <h2 class="section-title">Последняя активность</h2>
            <a href="#" class="view-all">Посмотреть все</a>
        </div>
        <div class="activity-list">
            <div class="activity-item">
                <div class="activity-icon new-order">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <div class="activity-content">
                    <p>Новый заказ <strong>#2847</strong> от Ивана Петрова</p>
                    <span class="activity-time">5 минут назад</span>
                </div>
            </div>
            <div class="activity-item">
                <div class="activity-icon user-reg">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                    </svg>
                </div>
                <div class="activity-content">
                    <p>Зарегистрирован новый пользователь</p>
                    <span class="activity-time">2 часа назад</span>
                </div>
            </div>
            <div class="activity-item">
                <div class="activity-icon completed">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <div class="activity-content">
                    <p>Заказ <strong>#2842</strong> выполнен</p>
                    <span class="activity-time">Сегодня, 14:30</span>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .admin-dashboard {
        max-width: 1400px;
        margin: 0 auto;
        padding: 2rem;
    }

    /* Header */
    .admin-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 3rem;
        gap: 2rem;
    }

    .admin-welcome {
        flex: 1;
    }

    .admin-title {
        display: flex;
        align-items: center;
        gap: 1rem;
        font-size: 2.5rem;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 0.5rem;
    }

    .admin-icon {
        color: #667eea;
    }

    .admin-subtitle {
        font-size: 1.25rem;
        color: #6b7280;
        margin: 0;
    }

    .admin-stats {
        display: flex;
        gap: 1.5rem;
    }

    .stat-card {
        display: flex;
        align-items: center;
        gap: 1rem;
        padding: 1.5rem;
        background: white;
        border-radius: 1rem;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        border: 1px solid #e5e7eb;
        min-width: 200px;
    }

    .stat-icon {
        width: 48px;
        height: 48px;
        border-radius: 0.75rem;
        background: #eff6ff;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #3b82f6;
    }

    .stat-info {
        display: flex;
        flex-direction: column;
    }

    .stat-value {
        font-size: 1.875rem;
        font-weight: 700;
        color: #1f2937;
        line-height: 1;
    }

    .stat-label {
        font-size: 0.875rem;
        color: #6b7280;
        margin-top: 0.25rem;
    }

    /* Quick Actions */
    .quick-actions {
        margin-bottom: 3rem;
    }

    .section-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: #1f2937;
        margin-bottom: 1.5rem;
    }

    .actions-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 1.5rem;
    }

    .action-card {
        display: flex;
        align-items: center;
        gap: 1rem;
        padding: 1.5rem;
        background: white;
        border-radius: 1rem;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        border: 1px solid #e5e7eb;
        text-decoration: none;
        color: inherit;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .action-card:not(.coming-soon):hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        border-color: #667eea;
    }

    .action-icon {
        width: 64px;
        height: 64px;
        border-radius: 1rem;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .action-icon.primary {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }

    .action-icon.secondary {
        background: linear-gradient(135deg, #6b7280, #9ca3af);
        color: white;
    }

    .action-icon.success {
        background: linear-gradient(135deg, #10b981, #059669);
        color: white;
    }

    .action-icon.warning {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .action-content {
        flex: 1;
    }

    .action-content h3 {
        font-size: 1.25rem;
        font-weight: 600;
        color: #1f2937;
        margin-bottom: 0.25rem;
    }

    .action-content p {
        color: #6b7280;
        margin: 0;
        font-size: 0.875rem;
    }

    .action-arrow {
        color: #9ca3af;
        transition: color 0.3s ease;
    }

    .action-card:hover .action-arrow {
        color: #667eea;
    }

    /* Coming Soon Cards */
    .action-card.coming-soon {
        opacity: 0.7;
        cursor: not-allowed;
    }

    .action-badge {
        position: absolute;
        top: 1rem;
        right: 1rem;
        background: #6b7280;
        color: white;
        padding: 0.25rem 0.75rem;
        border-radius: 1rem;
        font-size: 0.75rem;
        font-weight: 600;
    }

    /* Recent Activity */
    .recent-activity {
        background: white;
        border-radius: 1rem;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        border: 1px solid #e5e7eb;
        overflow: hidden;
    }

    .activity-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1.5rem;
        border-bottom: 1px solid #e5e7eb;
    }

    .view-all {
        color: #667eea;
        text-decoration: none;
        font-weight: 500;
        transition: color 0.3s ease;
    }

    .view-all:hover {
        color: #764ba2;
    }

    .activity-list {
        padding: 0;
    }

    .activity-item {
        display: flex;
        align-items: center;
        gap: 1rem;
        padding: 1.5rem;
        border-bottom: 1px solid #f3f4f6;
        transition: background-color 0.3s ease;
    }

    .activity-item:hover {
        background: #f8fafc;
    }

    .activity-item:last-child {
        border-bottom: none;
    }

    .activity-icon {
        width: 40px;
        height: 40px;
        border-radius: 0.75rem;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .activity-icon.new-order {
        background: #dbeafe;
        color: #1d4ed8;
    }

    .activity-icon.user-reg {
        background: #f0f9ff;
        color: #0369a1;
    }

    .activity-icon.completed {
        background: #dcfce7;
        color: #166534;
    }

    .activity-content {
        flex: 1;
    }

    .activity-content p {
        margin: 0 0 0.25rem 0;
        color: #374151;
        font-weight: 500;
    }

    .activity-time {
        font-size: 0.875rem;
        color: #6b7280;
    }

    /* Responsive */
    @media (max-width: 1024px) {
        .admin-header {
            flex-direction: column;
        }

        .admin-stats {
            width: 100%;
            justify-content: flex-start;
        }
    }

    @media (max-width: 768px) {
        .admin-dashboard {
            padding: 1rem;
        }

        .admin-title {
            font-size: 2rem;
        }

        .admin-stats {
            flex-direction: column;
            width: 100%;
        }

        .stat-card {
            min-width: auto;
        }

        .actions-grid {
            grid-template-columns: 1fr;
        }

        .activity-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 1rem;
        }
    }

    @media (max-width: 480px) {
        .action-card {
            flex-direction: column;
            text-align: center;
            padding: 1.5rem 1rem;
        }

        .action-content {
            text-align: center;
        }
    }
</style>