<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "application".
 *
 * @property int $id
 * @property int $user_id
 * @property int $category_id
 * @property int $product_id
 * @property int $count_product
 * @property string $date
 * @property string $adress
 * @property int $payment_method
 * @property string|null $content
 *
 * @property Category $category
 * @property Product $product
 * @property User $user
 */
class Application extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'application';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            ['user_id','default', 'value'=> Yii::$app->user->getId()],
            [['content'], 'default', 'value' => null],
            [['user_id', 'category_id', 'product_id', 'count_product', 'date', 'adress', 'payment_method'], 'required'],
            [['user_id', 'category_id', 'product_id', 'count_product', 'payment_method'], 'integer'],
            [['content'], 'string'],
            [['date'], 'string', 'max' => 20],
            [['adress'], 'string', 'max' => 255],
            [['category_id'], 'exist', 'skipOnError' => true, 'targetClass' => Category::class, 'targetAttribute' => ['category_id' => 'id']],
            //[['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
            [['product_id'], 'exist', 'skipOnError' => true, 'targetClass' => Product::class, 'targetAttribute' => ['product_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'category_id' => 'Category ID',
            'product_id' => 'Product ID',
            'count_product' => 'Количество товара',
            'date' => 'Дата доставки',
            'adress' => 'Адрес доставки',
            'payment_method' => 'Выберите способ оплаты',
            'content' => 'Пожелание',
        ];
    }

    /**
     * Gets query for [[Category]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return $this->hasOne(Category::class, ['id' => 'category_id']);
    }

    /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProduct()
    {
        return $this->hasOne(Product::class, ['id' => 'product_id']);
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

}
